<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:ns1="http://www.mf.gov.pl/SENT/2017/12/08/SENT_185.xsd"
				xmlns:tp="http://www.mf.gov.pl/SENT/2017/12/08/STypes.xsd">
	<xsl:template match="ns1:SENT_185">
		<!-- TODO: Auto-generated template -->
		<html>
			<head>
        <style>
          * {
          -webkit-print-color-adjust: exact !important;
          color-adjust: exact !important;
          }

          @media print {
          body {-webkit-print-color-adjust: exact;}
          }

          body {
          font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
          margin: 0 auto;
          padding: 0 auto;
          }

          .sent-xslt {
          border-collapse: initial;
          }

          .sent-xslt h1 {
          padding: 6px 4px 4px 10px;
          color:#000000;
          margin-top: 0;
          background-color:#c5c2c2;
          font-weight: normal;
          font-size: 12px;
          margin-bottom: 0;
          border-bottom: 1px solid #c8c9ca;
          }

          .sent-xslt .s1 {
          max-width: 1220px;
          border: 1px solid #c8c9ca;
          }

          .sent-xslt .t1 {
          position: relative;
          display: table;
          width: 100%;
          }

          .sent-xslt .grupName {
          font-size: 12px;
          margin: 0 !important;
          font-weight: bold;
          display:block;
          color: #000000;
          background-color:#dbddde;
          padding:5px 5px 5px 10px;
          border-top: 1px solid #dbddde;
          }

          .sent-xslt .element-1 {
          font-size: 12px;
          font-weight: normal;
          }

          .sent-xslt .element-2 {
          font-size: 14px;
          font-weight: normal;
          color: #008540;
          }

          .sent-xslt .grupInfo p {
          margin: 1px 0 1px 10px;
          font-weight: bold;
          font-size: 12px;
          }

          .sent-xslt .grupInfo {
          border-top: 1px solid #dbddde;
          }

          .sent-xslt .oilstatus {
          margin: 0 5px 0 -5px;
          margin: 2px 0 1px 10px;
          font-size: 14px;
          padding-bottom: 12px;
          color: red;
          }

          .sent-xslt .info1 {
          width: 50%;
          float: left;
          display: table-cell;
          padding: 4px 0px;
          }

          .sent-xslt .lang ul {
          margin: 0 auto;
          padding: 0;
          }

          .sent-xslt .lang ul li {
          display: inline;
          margin-left: 10px;
          }

          .sent-xslt .table {
          display: table;
          width: 99%;
          margin: 4px 0 15px 7px;
          border-spacing: 0 0;
          border-top: 1px solid #999999;
          border-left: 1px solid #999999;
          }

          .sent-xslt .table-header {
          font-size: 11px;
          font-weight: bold;
          padding: 5px;
          background-color: #ececec;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }

          .sent-xslt .table-element {
          font-size: 12px;
          font-weight: normal;
          padding: 2px 5px;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }

          .sent-xslt .table-element2 {
          font-size: 12px;
          font-weight: normal;
          padding: 0;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }

          .sent-xslt .table-element3 {
          font-size: 12px;
          font-weight: bold;
          border: 1px #999999;
          border-top-style: solid;
          margin: 0;
          }

          .sent-xslt .table-element p {
          margin-left: 0;
          }

          .sent-xslt .table-element3 p {
          margin-left: 0;
          padding: 0px 5px;
          }

        </style>
			</head>
      <body>
        <div class="sent-xslt">
          <section class="sent-xslt s1">
            <h1>SENT185 - LISTA UMÓW PODMIOTU SPRZEDAJĄCEGO</h1>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName">INFORMACJE DOTYCZĄCE ZAPYTANIA</p>
              <div class="sent-xslt t1">
                <div class="sent-xslt grupInfo">
                  <div class="sent-xslt info1">
                    <p>
                      <span class="sent-xslt element-1">Suma kontrolna: </span>
                      <xsl:value-of select="ns1:ResponseInfo/ns1:ChecksumOfSourceDocument"/>
                    </p>
                  </div>
                  <xsl:if test="ns1:ResponseInfo/ns1:SourceDocumentId !=''">
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-1">Numer własny zgłoszenia: </span>
                        <xsl:value-of select="ns1:ResponseInfo/ns1:SourceDocumentId"/>
                      </p>
                    </div>
                  </xsl:if>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName">DANE IDENTYFIKACYJNE PODMIOTU SPRZEDAJĄCEGO</p>
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-1">Identyfikator idSISC: </span>
                    <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderInfo/tp:IdSisc"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1">Nazwa pełna: </span>
                    <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderInfo/tp:TraderOrPersonName"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1">Typ identyfikatora: </span>
                    <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderInfo/tp:TraderIdentityType"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1">Numer identyfikatora: </span>
                    <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderInfo/tp:TraderIdentityNumber"/>
                  </p>
                </div>
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-2">Adres siedziby</span>
                  </p>
                  <xsl:variable name="ulica">
                    <xsl:choose>
                      <xsl:when test="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:FlatNumber != ''">
                        <p>
                          <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:Street"/>
                          <xsl:text>&#160;</xsl:text> <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:HouseNumber"/>&#160;/&#160;<xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:FlatNumber"/>
                        </p>
                      </xsl:when>
                      <xsl:otherwise>
                        <p>
                          <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:Street"/>
                          <xsl:text>&#160;</xsl:text>
                          <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:HouseNumber"/>
                        </p>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:variable>
                  <p>
                    <xsl:value-of select="$ulica"/>
                  </p>
                  <p>
                    <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:PostalCode"/>
                    <xsl:text>&#160;</xsl:text>
                    <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:City"/>
                    <xsl:if test="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:City != ''">,</xsl:if>
                    <xsl:text>&#160;</xsl:text>
                    <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:Country"/>
                  </p>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName">INFORMACJE O UMOWACH PODMIOTU SPRZEDAJĄCEGO</p>
              <div class="sent-xslt grupInfo">
                  <table class="sent-xslt table">
                    <tr>
                      <td class="sent-xslt table-header" style='width: 8%'>Numer umowy</td>
                      <td class="sent-xslt table-header" style='width: 7%'>Status</td>
                      <td class="sent-xslt table-header" style='width: 8%'>Data rejestracji</td>
                      <td class="sent-xslt table-header" style='width: 11%'>Rejestrujący</td>
                      <td class="sent-xslt table-header" style='width: 8%'>Data modyfikacji</td>
                      <td class="sent-xslt table-header" style='width: 10%'>Modyfikujący</td>
                      <td class="sent-xslt table-header" style='width: 9%'>Identyfikator odbiorcy</td>
                      <td class="sent-xslt table-header" style='width: 11%'>Nazwa odbiorcy</td>
                      <td class="sent-xslt table-header" style='width: 9%'>Okres umowy</td>
                      <td class="sent-xslt table-header" style='width: 6%'>Ilość oleju opałowego</td>
                      <td class="sent-xslt table-header" style='width: 12%'>Zestawienie na dzień</td>
                    </tr>
                    <xsl:for-each select="ns1:AgreementsRegisteredBySender">
                      <tr>

                        <td class="sent-xslt table-element">
                          <span class="sent-xslt element-1">
                            <xsl:value-of select="tp:AgreementNumber"/>
                          </span>
                        </td>
                        <td class="sent-xslt table-element">
                          <span class="sent-xslt element-1">
                            <xsl:choose>
                              <xsl:when test="tp:AgreementStatus = '0'">
                                <span>zarejestrowana</span>
                              </xsl:when>
                              <xsl:when test="tp:AgreementStatus = '2'">
                                <span>aktywna</span>
                              </xsl:when>
                              <xsl:when test="tp:AgreementStatus = '3'">
                                <span>zakończona</span>
                              </xsl:when>
                              <xsl:when test="tp:AgreementStatus = '4'">
                                <span>anulowana</span>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="tp:AgreementStatus"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </span>
                        </td>
                        <td class="sent-xslt table-element">
                          <span class="sent-xslt element-1">
                            <xsl:choose>
                              <xsl:when test="string-length(tp:CreationDate) > 10">
                                <xsl:value-of select="substring-before(tp:CreationDate, 'T')"/><br /><xsl:value-of select="substring(tp:CreationDate, 12,8)"/>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="tp:CreationDate"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </span>
                        </td>
                        <td class="sent-xslt table-element">
                          <span class="sent-xslt element-1">
                            <xsl:value-of select="tp:Creator"/>
                          </span>
                        </td>
                        <td class="sent-xslt table-element">
                          <span class="sent-xslt element-1">
                            <xsl:choose>
                              <xsl:when test="string-length(tp:ModificationDate) > 10">
                                <xsl:value-of select="substring-before(tp:ModificationDate, 'T')"/><br /><xsl:value-of select="substring(tp:ModificationDate, 12,8)"/>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="tp:ModificationDate"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </span>
                        </td>
                        <td class="sent-xslt table-element">
                          <span class="sent-xslt element-1">
                            <xsl:value-of select="tp:Modifier"/>
                          </span>
                        </td>

                        <td class="sent-xslt table-element">
                          <span class="sent-xslt element-1">
                            <xsl:value-of select="tp:RecipientIdentityType"/>&#160;<xsl:value-of select="tp:RecipientIdentityNumber"/>
                          </span>
                        </td>
                        <td class="sent-xslt table-element">
                          <span class="sent-xslt element-1">
                            <xsl:value-of select="tp:RecipientName"/>
                          </span>
                        </td>
                        <td class="sent-xslt table-element">
                          <span class="sent-xslt element-1">
                            od:
                            <xsl:choose>
                              <xsl:when test="string-length(tp:DateAgreementFrom) > 10">
                                <xsl:value-of select="substring-before(tp:DateAgreementFrom, '+')"/>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="tp:DateAgreementFrom"/>
                              </xsl:otherwise>
                            </xsl:choose>
                            do:
                            <xsl:choose>
                              <xsl:when test="string-length(tp:DateAgreementTo) > 10">
                                <xsl:value-of select="substring-before(tp:DateAgreementTo, '+')"/>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="tp:DateAgreementTo"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </span>
                        </td>
                        <td class="sent-xslt table-element">
                          <span class="sent-xslt element-1">
                            <xsl:value-of select="tp:AgreementAmountOfGoods"/>&#160;<xsl:value-of select="tp:UnitOfMeasure"/>
                          </span>
                        </td>
                        <td class="sent-xslt table-element">
                          <xsl:if test="tp:AgreementBalancePerDay !=''">
                          <span class="sent-xslt element-1">
                            <xsl:choose>
                              <xsl:when test="string-length(tp:AgreementBalancePerDay) > 10">
                                <xsl:value-of select="substring-before(tp:AgreementBalancePerDay, '+')"/>:
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="tp:AgreementBalancePerDay"/>:
                              </xsl:otherwise>
                            </xsl:choose>
                            <xsl:value-of select="tp:AgreementBalance"/>&#160;<xsl:value-of select="tp:UnitOfMeasure"/>
                          </span>
                        </xsl:if>
                        </td>
                      </tr>
                    </xsl:for-each>
                  </table>
              </div>
            </div>
          </section>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
